<?php
/* --------------------------------------------------------------
 BootableServiceProvider.php 2020-04-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\ServiceProviders\Abstraction;

/**
 * Interface BootableServiceProvider
 * @package Gambio\Core\Application\ServiceProviders\Abstraction
 */
interface BootableServiceProvider extends ServiceProvider
{
    /**
     * Boots the service provider.
     *
     * The boot method will be invoked as soon as the
     * service provider gets registered to the container.
     */
    public function boot(): void;
}